package {
	
	import away3d.containers.ObjectContainer3D;
	import away3d.core.base.Face;
	import away3d.core.base.Mesh;
	import away3d.core.base.Object3D;
	import away3d.events.LoaderEvent;
	import away3d.lights.DirectionalLight3D;
	import away3d.loaders.Collada;
	import away3d.loaders.Object3DLoader;
	import away3d.materials.ColorMaterial;
	import away3d.materials.ShadingColorMaterial;
	import away3d.materials.WhiteShadingBitmapMaterial;
	import away3d.materials.WireColorMaterial;
	import away3d.primitives.Cube;
	import away3d.primitives.Plane;
	
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensySequence;
	import com.flashdynamix.motion.TweensyTimeline;
	
	import fl.motion.easing.Back;
	import fl.motion.easing.Cubic;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Matrix;
	
	import org.libspark.thread.Monitor;
	import org.libspark.thread.utils.EventDispatcherThread;

	public class LogoLogoDemo extends EventDispatcherThread implements IDemoThread {
		
		[Embed(source='../bin-debug/models/max.png')]
		private static const maxTexClass:Class;
		private static const maxTex:BitmapData = Bitmap(new maxTexClass()).bitmapData;
		
		[Embed(source='../assets/icons.png')]
		private static const iconTexClass:Class;
		private static const iconTex:BitmapData = Bitmap(new iconTexClass()).bitmapData;
		
		private var _ctx:Context;
		private var _hole:Object3DLoader;
		private var _max:Object3DLoader;
		private var _maxMat:WhiteShadingBitmapMaterial;
		private var _icon:Object3DLoader;
		private var _iconMat:Array;
		private var _adobe:Object3DLoader;
		private var _adobeMat:WhiteShadingBitmapMaterial;
		private var _currentObj:Object3DLoader;
		private var _anime:TweensySequence;
		private var _monitor:Monitor;
		private var _closing:Boolean = false;
		
		public function LogoLogoDemo(ctx:Context) {
			this._ctx = ctx;
		}
		
		protected override function run():void {
//			var mat:WhiteShadingBitmapMaterial = new WhiteShadingBitmapMaterial(maxTex);
			this._hole = Collada.load('models/hole2.dae');
			this._hole.scale(0.1);
			this._ctx.arview.marker.addChild(this._hole);
			event(this._hole, LoaderEvent.LOAD_SUCCESS, this._onLoaded);
		}
		
		private function _onLoaded(e:Event):void {
			this._ctx.arview.filters = [
				new ColorMatrixFilter([
					1,  0, 0, 0, 0,
					0,  1, 0, 0, 0,
					0,  0, 1, 0, 0,
					1, -1, 1, 1, 0
				])
			];

			var hole:ObjectContainer3D = ObjectContainer3D(this._hole.handle);
			var mesh:Mesh = hole.children[0] as Mesh;
			mesh.bothsides = true;
			var green:ColorMaterial = new ColorMaterial(0x00ff00);
			for each (var f:Face in mesh.faces) {
				f.back = green;
			}
			var black:ColorMaterial = new ColorMaterial(0x0, {alpha: 0.35});
			for (var i:int = 1; i <= 9; i++) {
				var y:Number = i / 9 * 2000;
				var plane:Plane = new Plane({material:black, width:780, height:780, y:-y});
				hole.addChild(plane);
			}
			
			this._monitor = new Monitor();
			
			this._loadNext();
		}

		private function _loadNext():void {
			if (Math.random() < 0.8) { // icon
				if (!this._iconMat) {
					this._iconMat = [];
					for (var i:int = 0; i < 8; i++) {
						var b:BitmapData = new BitmapData(125, 125, false, 0x0);
						b.draw(iconTex, new Matrix(1, 0, 0, 1, -125 * i, 0));
						this._iconMat.push(new WhiteShadingBitmapMaterial(b));
					}
				}
				if (!this._icon) {
					this._icon = Collada.load('models/icon.dae', {material:this._iconMat[int(Math.random() * 8)]});
					this._ctx.arview.marker.addChild(this._icon);
					event(this._icon, LoaderEvent.LOAD_SUCCESS, this._onLoadObject);
					this._currentObj = this._icon;
				} else {
					var mat:WhiteShadingBitmapMaterial = this._iconMat[int(Math.random() * 8)];
					for each (var f:Face in ObjectContainer3D(this._icon.handle).children[0].faces) {
						f.material = mat;
					}
					this._ctx.arview.marker.addChild(this._icon.handle);
					this._currentObj = this._icon;
					this._onLoadObject();
				}
				
			} else if (Math.random() < 0.5) { // adobe
				if (!this._adobe) {
					this._adobeMat = new WhiteShadingBitmapMaterial(new BitmapData(1, 1, false, 0xd80100));
					this._adobe = Collada.load('models/adobe.dae', {material:this._adobeMat});
					this._ctx.arview.marker.addChild(this._adobe);
					event(this._adobe, LoaderEvent.LOAD_SUCCESS, this._onLoadObject);
					this._currentObj = this._adobe;
				} else {
					this._ctx.arview.marker.addChild(this._adobe.handle);
					this._currentObj = this._adobe;
					this._onLoadObject();
				}
				
			} else { // max
				if (!this._max) {
					this._maxMat = new WhiteShadingBitmapMaterial(maxTex);
					this._max = Collada.load('models/max.dae', {material:this._maxMat});
					this._ctx.arview.marker.addChild(this._max);
					event(this._max, LoaderEvent.LOAD_SUCCESS, this._onLoadObject);
					this._currentObj = this._max;
				} else {
					this._ctx.arview.marker.addChild(this._currentObj.handle);
					this._currentObj = this._max;
					this._onLoadObject();
				}
			}
		}
		
		private function _onLoadObject(e:Event = null):void {
			var obj:ObjectContainer3D = ObjectContainer3D(this._currentObj.handle);
			obj.rotationZ = 0;
			obj.scale(0.05);
			obj.y = -200;
			this._anime = new TweensySequence();
			this._anime.push(obj, {y:20}, 1, Cubic.easeOut, 1);
			this._anime.push(obj, {scaleX:0.1, scaleY:0.1, scaleZ:0.1}, 0.5, Back.easeOut);
			this._anime.push(obj.children[0], {rotationZ:360}, 1.5, Cubic.easeInOut);
			this._anime.push(obj.children[0], {rotationZ:720}, 1.5, Cubic.easeInOut);
			this._anime.push(obj, {scaleX:0.03, scaleY:0.03, scaleZ:0.03}, 0.35, Back.easeIn, 0.5);
			this._anime.start();
			this._anime.onComplete = this._monitor.notifyAll;
			
			this._monitor.wait();
			next(this._onCompleteAnime);
		}
		
		private function _onCompleteAnime():void {
			trace('_onCompleteAnime', this._closing);
			this._ctx.arview.marker.removeChild(this._currentObj.handle);
			if (this._closing) {
				this._anime.stop();
				this._anime = null;
			} else {
				next(this._loadNext);
			}
		}
		
		public function close():void {
			this._closing = true;
			this._monitor.notifyAll();
		}
		
		protected override function finalize():void {
			trace('finalize', this);
			this._ctx.arview.marker.removeChild(this._hole.handle);
			this._hole = null;
			if (this._max) {
				this._ctx.arview.marker.removeChild(this._max.handle);
				this._max = null;
				this._maxMat.bitmap.dispose();
				this._maxMat = null;
			}
			if (this._icon) {
				this._ctx.arview.marker.removeChild(this._icon.handle);
				this._icon = null;
				for each (var m:WhiteShadingBitmapMaterial in this._iconMat) {
					m.bitmap.dispose();
				}
				this._iconMat = null;
			}
			if (this._adobe) {
				this._ctx.arview.marker.removeChild(this._adobe.handle);
				this._adobe = null;
				this._adobeMat.bitmap.dispose();
				this._adobeMat = null;
			}
			this._ctx.arview.filters = [];
			this._ctx = null;
		}
	}
}